using System;
using System.Collections.Generic;
using System.Text;
using ComponentPro;

namespace AdvancedDemo.Samples.Template_and_Template_Class
{
    class Getting_Template_Reference : TemplateExampleBase
    {
        /// <summary>
        /// Generates output from a template file.
        /// </summary>
        /// <param name="templateSourceDirectory">The path to the directory that contains the template file.</param>
        /// <param name="templateFile">The template file path.</param>
        /// <param name="templateSource">The template source loaded from the template file.</param>
        /// <returns>The generated output.</returns>
        public override string Generate(string templateSourceDirectory, string templateFile, string templateSource)
        {
            StringBuilder gen = new StringBuilder();

            // Create a new instance of the TemplateEngine class.
            TemplateEngine dt = new TemplateEngine();

            dt.LoadTemplateClassesFromFile(templateSourceDirectory + "\\Sample.tpc");
            dt.LoadFromString(templateSource);

            dt.SetValue("a", 100);
            dt.SetValue("b", 2);
            dt.SetValue("c", 1);
            dt.SetValue("d", 8);

            // Find template "mytemplate" inside "myclass" and render it.
            Template tpl1 = dt.FindTemplate("global::myclass.mytemplate");
            string output = dt.Run(tpl1);
            gen.Append(output);
            // Find child template "child1" of "mytemplate" inside "myclass" and render it.
            Template tpl2 = dt.FindTemplate("global::myclass.mytemplate.child1");
            output = dt.Run(tpl2);
            gen.Append(output);
            // Find child template "child2" defined in Template.tpl and render it.
            Template tpl3 = dt.FindTemplate("child2");
            output = dt.Run(tpl3);
            gen.Append(output);
            // Render the mainly loaded template.
            output = dt.Run();
            gen.Append(output);

            return gen.ToString();
        }
    }
}
